



<html>
<head>
  <title>javabog.dk - Webprogrammering med Java Server Pages - XML, indholdssyndikering og webtjenester</title>
  <link rev="stylesheet" type="text/css" href="../typografi.css">
  <meta name="description" content="Lrebog i Java. Af Jacob Nordfalk. Udkommet hos Forlaget Globe">
  <meta name="keywords" content="designmnster, programmering, OOP, objekter, klasser, objektorienteret programmering, Java, JSP, lrebog, UML, IT">
</head>
<body bgcolor="#ffffff">



<a href='http://javabog.dk/'>javabog.dk</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel10.jsp'>&lt;&lt; forrige</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='indhold.jsp'>indhold</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel12.jsp'>n&aelig;ste &gt;&gt;</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kode/'>programeksempler</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='../index_JSP.html'>om bogen</a>

<H1 CLASS="western" STYLE="">11 <a name='afsn11'></a>XML,
indholdssyndikering og webtjenester</H1>
<DIV ID="Indholdsfortegnelse17">
  <P STYLE="margin-top: 0.5cm; margin-bottom: 0cm"><BR>
  </P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>11.1
  Introduktion til XML  212</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">11.1.1
  XML-formatet  212</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">11.1.2
  DOM - Dokumentets objektmodel  213</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">11.1.3
  XPath - stier i XML-dokumenter  214</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">11.1.4
  Transformering af XML-data (XSL)  214</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">11.1.5
  XML-behandling (SAX og DOM)  215</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">11.1.6
  Dokumenttypedefinitionen  215</FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>11.2
  XML-behandling i Java  216</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">11.2.1
  Brug af DOM og XPath  216</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">11.2.2
  Nem generering af XML fra Java-objekter  218</FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>11.3
  Syndikering (nyhedsf&oslash;dning)  219</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">11.3.1
  Nyhedskildernes format  220</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">11.3.2
  Fremvisning med RSS-taglib  222</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">11.3.3
  Fremvisning med Java  223</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">11.3.4
  Syndikering med JSTL  225</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">11.3.5
  Mere information og nyhedskilder p&aring; nettet  226</FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>11.4
  Principper i metodekald over netv&aelig;rk  227</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">11.4.1
  Systemer til metodekald over netv&aelig;rk  227</FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>11.5
  Webtjenester  228</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">11.5.1
  SOAP - kommunikation med webtjenesten  228</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">11.5.2
  WSDL - beskrivelsen af webtjenesten  229</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">11.5.3
  UDDI - offentlige lister over webtjenester  229</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">11.5.4
  Bruge Googles webtjenester til s&oslash;gninger  229</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">11.5.5
  Genere Java-API fra webtjeneste (WSDL)  230</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">11.5.6
  Generere webtjeneste (WSDL) fra Java-klasse  231</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">11.5.7
  Avanceret: Strukturen i WSDL- og SOAP-filer  232</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">11.5.8
  Yderligere l&aelig;sning  235</FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>11.6
  Test dig selv  235</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>11.7
  Resum&eacute;  236</B></FONT></FONT></P>
</DIV>

<P CLASS="kapiteloversigt-western"><SPAN LANG="da-DK">Dette kapitel
foruds&aelig;tter <a href='kapitel3.jsp'>kapitel 3</a>, Interaktive sider. Det er kompakt
skrevet og behandler en r&aelig;kke avancerede emner, s&aring; lidt
forh&aring;ndskendskab er en fordel.</SPAN></P>
<H2 CLASS="western" STYLE="">11.1 <a name='afsn11.1'></a>Introduktion
til XML</SPAN></H2>
<P CLASS="western">XML (eXtenisble Markup Language) minder meget om
HTML, men har et andet form&aring;l:</P>
<UL>
  <LI><P CLASS="western">HTML er beregnet p&aring; <I>dokumenter der
  skal vises for et menneske</I> og det indeholder derfor b&aring;de
  tekst og formateringskoder, der instruerer fremviseren (netl&aelig;seren)
  om, hvordan tekstindholdet skal vises.</P>
  <LI><P CLASS="western">XML er beregnet til at <I>overf&oslash;re
  data mellem programmer</I> - og det indeholder derfor (tekst-)data
  og koder, der instruerer programmet om, hvordan disse data skal
  fortolkes. 
  </P>
</UL>
<P CLASS="western">XML-teknologier har v&aelig;ret i en rivende
udvikling inden for de seneste par &aring;r og emnet kunne nemt fylde
en separat bog. Af pladshensyn vil de f&oslash;lgende afsnit derfor
blot definere de mest centrale begreber inden for XML og behandle de
aspekter, der er relevant i forbindelse med JSP og
webserverprogrammering.</P>
<H3 CLASS="western">11.1.1 <a name='afsn11.1.1'></a>XML-formatet</H3>
<P CLASS="western">En simpel XML-fil kunne se s&aring;ledes ud:</P>
<P ALIGN=CENTER STYLE="margin-top: 0.11cm; margin-bottom: 0.11cm"><FONT SIZE=2 STYLE="font-size: 9pt"><I>persongalleri.xml</I></FONT></P>
<PRE CLASS="kode-western">&lt;?xml version=&quot;1.0&quot; encoding=&quot;iso-8859-1&quot;?&gt; <I>&lt;!-- filnavn: persongalleri.xml --&gt;</I>
&lt;galleri&gt;
  &lt;titel&gt;Betydningsfulde personer&lt;/titel&gt;

  &lt;person id=&quot;1&quot;&gt;
    &lt;fornavn&gt;Troels&lt;/fornavn&gt;
    &lt;efternavn&gt;Nordfalk&lt;/efternavn&gt;
    &lt;f&oslash;dselsdato &aring;r=&quot;1972&quot; m&aring;ned=&quot;08&quot; dag=&quot;11&quot; /&gt;
  &lt;/person&gt;

  &lt;person id=&quot;2&quot;&gt;
    &lt;fornavn&gt;Jacob&lt;/fornavn&gt;
    &lt;efternavn&gt;Nordfalk&lt;/efternavn&gt;
    &lt;f&oslash;dselsdato &aring;r=&quot;1971&quot; m&aring;ned=&quot;01&quot; dag=&quot;01&quot; /&gt;
    &lt;v&aelig;rker&gt;
      &lt;v&aelig;rk type=&quot;bog&quot;&gt;
        &lt;titel&gt;Objektorienteret programmering i Java&lt;/titel&gt;
        &lt;isbn udgave=&quot;1&quot;&gt;8779000940&lt;/isbn&gt;
        &lt;isbn udgave=&quot;2&quot;&gt;8779001378&lt;/isbn&gt;
      &lt;/v&aelig;rk&gt;
      &lt;v&aelig;rk type=&quot;hjemmeside&quot;&gt;
        &lt;titel&gt;javabog.dk&lt;/titel&gt;
        &lt;url&gt;http://javabog.dk&lt;/url&gt;
      &lt;/v&aelig;rk&gt;
      &lt;v&aelig;rk type=&quot;bog&quot;&gt;
        &lt;titel&gt;Videreg&aring;ende programmering i Java&lt;/titel&gt;
        &lt;isbn udgave=&quot;1&quot;&gt;8779001955&lt;/isbn&gt;
      &lt;/v&aelig;rk&gt;
    &lt;/v&aelig;rker&gt;
  &lt;/person&gt;
&lt;/galleri&gt;</PRE><P CLASS="western">
En XML-fil er alts&aring; en tekstfil med data i nogle navngivne
strukturer. Alle koder skal afsluttes igen med en slutkode, som i</P>
<PRE CLASS="kode-western">    &lt;fornavn&gt;Jacob&lt;/fornavn&gt;</PRE><P CLASS="western">
er der intet mellem start- og slutkoden kan det forkortes ved at
afslutte med /&gt;, f.eks.:</P>
<PRE CLASS="kode-western">    &lt;f&oslash;dselsdato &aring;r=&quot;1971&quot; m&aring;ned=&quot;01&quot; dag=&quot;01&quot; <B>/&gt;</B></PRE><P CLASS="western">
Denne kode svarer pr&aelig;cist til:</P>
<PRE CLASS="kode-western">    &lt;f&oslash;dselsdato &aring;r=&quot;1971&quot; m&aring;ned=&quot;01&quot; dag=&quot;01&quot;&gt;&lt;/f&oslash;dselsdato&gt;</PRE><P CLASS="western">
En af de smarte ting ved XML-formatet (og HTML-formatet) i forhold
til andre filformater er, at det kan udvides: Et program der f.eks
ikke forst&aring;r afsnittet &lt;v&aelig;rker&gt; i ovenst&aring;ende
XML-fil kan nemt springe dette over. P&aring; denne m&aring;de kan et
filformat senere udvides med flere data, uden at det p&aring;virker
eksisterende programmer, der bruger filformatet.</P>
<P CLASS="western">Denne egenskab er en af grundene til at HTML blev
en succes: efterh&aring;nden som netl&aelig;serne udviklede sig og
kunne fremvise stadigt mere sofistikerede ting, kunne HTML-koden
udvides med flere og flere elementer og attributter og stadigv&aelig;k
v&aelig;re l&aelig;sbar og vises rimeligt i gamle netl&aelig;sere,
der ikke forstod de nye elementer og attributter.</P>
<P CLASS="western">XML har gennemg&aring;et en rivende udvikling og
der er et s&aring; stort antal m&aring;der at arbejde med XML p&aring;,
at det kan virke uoverskueligt til at begynde med. 
</P>
<H3 CLASS="western">11.1.2 <a name='afsn11.1.2'></a>DOM - Dokumentets objektmodel</H3>
<P CLASS="western">DOM (Document Object Model) er en m&aring;de at
repr&aelig;sentere et XML-dokument: Hvert element repr&aelig;senteres
som et objekt med nogle attributter og underelementer, s&aring;dan at
dokumentet fremst&aring;r som <I>et tr&aelig; af objekter</I>. 
</P>
<P CLASS="western">Udviklingsv&aelig;rkt&oslash;jer kan nemt vise og
navigere i DOM-tr&aelig;et. Her ses DOM-tr&aelig;et af
persongalleri.xml som Borland JBuilder viser det (nogle grene i tr&aelig;et
er foldet sammen):</P>
<P CLASS="western" ALIGN=CENTER><IMG SRC="bog12_html_m3c48b6c3.png" NAME="Grafik52" ALIGN=BOTTOM BORDER=0></P>
<P CLASS="western">Her er 'roden' i tr&aelig;et &lt;galleri&gt;, som
har 3 'grene' i form af underelementerne &lt;titel&gt;, &lt;person&gt;
og &lt;person&gt;, som hver  kan have flere underelementer. 
</P>
<H3 CLASS="western" STYLE="">11.1.3 <a name='afsn11.1.3'></a>XPath -
stier i XML-dokumenter</H3>
<P CLASS="western">XML er s&aring; smart indrettet, at man kan angive
'stier' til at finde frem til elementer i et givent dokument. Der er
et helt sprog, kaldet XPath, som bruges til at udv&aelig;lge data i
DOM-tr&aelig;et.</P>
<P CLASS="western">Disse stier kan v&aelig;re relative, kan v&aelig;lge
flere elementer og en lang r&aelig;kke andre ting. 
</P>
<P CLASS="western">Her er et par eksempler p&aring; XPath-udtryk:</P>
<UL>
  <LI><P CLASS="western"><B>&quot;galleri/person[@id=2]/fornavn/text()&quot;</B>
  anvendt p&aring; ovenst&aring;ende XML-fil persongalleri.xml vil det
  finde &lt;galleri&gt;-indgangen, under denne finde
  &lt;person&gt;-indgangen med attributten id=2 og under den finde
  &lt;fornavn&gt;-indgangens tekst, d.v.s. strengen:</P>
</UL>
<PRE CLASS="kode-western" STYLE="margin-left: 0.5cm">Jacob</PRE>
<UL>
  <LI><P CLASS="western"><B>&quot;//*/titel/text()&quot;</B> leder
  hele tr&aelig;et igennem og finder alle &lt;titel&gt;-koder, uanset
  hvor det er i DOM-tr&aelig;et:</P>
</UL>
<PRE CLASS="kode-western" STYLE="margin-left: 0.5cm">Betydningsfulde personer<BR>Objektorienteret programmering i Java<BR>javabog.dk<BR>Videreg&aring;ende programmering i Java</PRE>
<UL>
  <LI><P CLASS="western"><B>&quot;//*/isbn/../titel/text()&quot;</B> 
  leder tr&aelig;et efter &lt;isbn&gt;-koder, g&aring;r et niveau op
  (til &lt;v&aelig;rk&gt;) og finder titlen af v&aelig;rket, s&aring;dan
  at man f&aring;r en liste over alle v&aelig;rker med ISBN:</P>
</UL>
<PRE CLASS="kode-western" STYLE="margin-left: 0.5cm">Objektorienteret programmering i Java<BR>Videreg&aring;ende programmering i Java</PRE>
<UL>
  <LI><P CLASS="western"><B>&quot;galleri/person/v&aelig;rker/v&aelig;rk[@type=&quot;hjemmeside&quot;]/titel/text()&quot;</B>
  finder alle v&aelig;rker af type hjemmeside og udskriver titlen:</P>
</UL>
<PRE CLASS="kode-western" STYLE="margin-left: 0.5cm">javabog.dk</PRE>
<P CLASS="western">&Oslash;nsker du at vide mere om XPath-udtryk og
lave mere avancerede udtryk s&aring; se f.eks.:</P>
<UL>
  <LI><P CLASS="western">'How XPath Works' i 'The J2EE 1.4 Tutorial':
  <BR><A CLASS="western" HREF="http://java.sun.com/j2ee/1.4/docs/tutorial/doc/JAXPXSLT3.html">http://java.sun.com/j2ee/1.4/docs/tutorial/doc/JAXPXSLT3.html</A>
    </P>
  <LI><P CLASS="western"><A CLASS="western" HREF="http://www.w3schools.com/xpath/">http://www.w3schools.com/xpath/</A>
    </P>
</UL>
<H3 CLASS="western">11.1.4 <a name='afsn11.1.4'></a>Transformering af XML-data (XSL)</H3>
<P CLASS="western">XML Style Sheet Language (XSL) er en m&aring;de at
transformere et XML-dokuments data til et hvilken som helst andet
tekstformat, f.eks. HTML. Et XSL-dokumenter g&oslash;r brug af
XPath-sproget til at bestemme hvilke dele af XML-dokumentet, der skal
ind hvor.</P>
<P CLASS="western">XSL fungerer, popul&aelig;rt sagt, lige som god
gammeldags brevfletning: XSL-dokumentet er brevfletningsskabelonen,
XML-dokumentet er adresselisten. N&aring;r de flettes f&aring;r man
breve ud, der ligner skabelonen, men hvor alle felterne i skabelonen
er erstattet med data fra XML-dokumentet.</P>
<P CLASS="western">&Oslash;nsker du at vide mere om at skrive
XSL-transformering s&aring; se f.eks.:</P>
<UL>
  <LI><P CLASS="western">'Transforming XML Data with XSLT' i 'The J2EE
  1.4 Tutorial':
  <BR><A CLASS="western" HREF="http://java.sun.com/j2ee/1.4/docs/tutorial/doc/JAXPXSLT6.html">http://java.sun.com/j2ee/1.4/docs/tutorial/doc/JAXPXSLT6.html</A>
    </P>
  <LI><P CLASS="western"><A CLASS="western" HREF="http://www.w3schools.com/xsl/">http://www.w3schools.com/xsl/</A>
   
  </P>
</UL>

<H3 CLASS="western">11.1.5 <a name='afsn11.1.5'></a>XML-behandling (SAX og DOM)</H3>
<P CLASS="western">Der findes to fundamentalt forskellige m&aring;der
at l&aelig;se en XML-fil p&aring;:</P>
<UL>
  <LI><P CLASS="western">SAX (Simple Api for XML processing): Filen
  genneml&oslash;bes fra en ende til en anden, og hvert element, der
  m&oslash;des afstedkommer en <I>h&aelig;ndelse</I>, der skal fanges.
    </P>
  <LI><P CLASS="western">DOM (Document Object Model): Hele filen
  indl&aelig;ses og hvert element repr&aelig;senteres som et objekt
  med nogle attributter og underelementer, s&aring;dan at dokumentet
  fremst&aring;r som et tr&aelig; af objekter.</P>
</UL>
<P CLASS="western">Et program der bruger SAX registrerer en lytter,
der f&aring;r kaldt metoder, mens dokumentet genneml&oslash;bes.
SAX-m&aring;den med seriel l&aelig;sning er hurtig, har lavt
hukommelsesforbrug og er velegnet til at tr&aelig;kke nogle data ud
at et XML-dokument.</P>
<P CLASS="western">DOM-m&aring;den er langsommere og bruger mere
hukommelse (da hele dokumentet er repr&aelig;senteret i hukommelsen),
men kan v&aelig;re mere overskuelig at programmere, da den tillader
at man hopper frem og tilbage i objekttr&aelig;et. Den husker alle
elementerne, ogs&aring; dem programmet ikke forst&aring;r, og er
derfor velegnet til at redigere i XML-dokumenter.</P>

<H3 CLASS="western">11.1.6 <a name='afsn11.1.6'></a>Dokumenttypedefinitionen</H3>
<P CLASS="western">Et XML-dokument kan (men skal ikke) have
tilknyttet en beskrivelse af hvilke elementer, der er tilladt i
dokumentet. Der findes to m&aring;der at definere dokumentformatet:</P>
<UL>
  <LI><P CLASS="western">DTD (Document Type Definition) er en &aelig;ldre
  standard.</P>
  <LI><P CLASS="western">XML Schema er en nyere standard. XML
  Schema-dokumenter er i sig selv XML.</P>
</UL>
<P CLASS="western">DTD er det letteste at l&aelig;se for mennesker,
men XML Schema er lige s&aring; stille i gang med at erstatte DTD,
bl.a. fordi det kan udtrykke meget mere komplekse regler for
dokumenttypens elementer.</P>
<P CLASS="western">Som udvikler kommer man nok aldrig til at l&aelig;se
en dokumenttypedefinition, da der n&aelig;sten altid er en vejledning
henvendt til mennesker, som er meget lettere at l&aelig;se. 
</P>
<P CLASS="western">Derfor har de fleste ikke brug for andet end en
overfladisk viden om, hvad det er, der skal st&aring; &oslash;verst i
deres XML-fil, hvis de vil henvise til en dokumenttypedefinition af
den ene eller den anden slags.</P>

<H4 CLASS="western">Eksempel</H4>
<P CLASS="western"><SPAN LANG="da-DK">Webapplikationers
driftsbeskrivelsesfil web.xml (se <a href='kapitel7.jsp#afsn7.5'>afsnit 7.5</a>) er et eksempel p&aring;
en XML-fil med en dokumenttypedefinition. </SPAN>
</P>
<P CLASS="western" STYLE="">I starten af
web.xml-fil i version 2.3 henvises til et DTD:</P>
<P ALIGN=CENTER STYLE="margin-top: 0.11cm; margin-bottom: 0.11cm"><FONT SIZE=2 STYLE="font-size: 9pt"><I>starten
af web.xml i version 2.3 henviser til et DTD</I></FONT></P>
<PRE CLASS="kode-western">&lt;?xml version=&quot;1.0&quot;?&gt;
<SPAN LANG="da-DK">&lt;!DOCTYPE web-app PUBLIC &quot;-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN&quot; &quot;http://java.sun.com/dtd/web-app_2_3.dtd&quot;&gt;</SPAN>
<SPAN LANG="da-DK">&lt;web-app&gt;</SPAN></PRE>
<P CLASS="western">I web.xml i version 2.4 skiftede man over til XML
Schema:</P>
<P ALIGN=CENTER STYLE="margin-top: 0.11cm; margin-bottom: 0.11cm"><FONT SIZE=2 STYLE="font-size: 9pt"><I>starten
af web.xml i version 2.4 henviser til et XML Schema</I></FONT></P>
<PRE CLASS="kode-western">&lt;?xml version=&quot;1.0&quot;?&gt;
&lt;web-app xmlns=&quot;http://java.sun.com/xml/ns/j2ee&quot;
    xmlns:xsi=&quot;http://www.w3.org/2001/XMLSchema-instance&quot;
    xsi:schemaLocation=&quot;http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd&quot;
    version=&quot;2.4&quot;&gt;</PRE><P CLASS="western">
Er du virkelig interesseret i at se hvordan dokumenttypedefinitioner
ser ud kan du se:</P>
<UL>
  <LI><P CLASS="western">Eksempel p&aring; <SPAN STYLE="text-decoration: none">DTD
  p&aring;</SPAN> <A CLASS="western" HREF="http://java.sun.com/dtd/web-app_2_3.dtd"><SPAN LANG="da-DK">http://java.sun.com/dtd/web-app_2_3.dtd</SPAN></A></P>
  <LI><P CLASS="western"><SPAN LANG="da-DK">Eksempel p&aring; XML
  Schema <SPAN STYLE="text-decoration: none">p&aring;</SPAN></SPAN>
  <A CLASS="western" HREF="http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd">http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd</A>
    </P>
</UL>
<H2 CLASS="western">11.2 <a name='afsn11.2'></a>XML-behandling i Java</SPAN></H2>
<P CLASS="western">Der findes meget stor underst&oslash;ttelse for
XML-behandling i Java. Det f&oslash;lgende er derfor kun et par
eksempler p&aring;, hvordan XML-v&aelig;rkt&oslash;jerne kan bruges i
forbindelse med webprogrammering og JSP.</P>
<H3 CLASS="western">11.2.1 <a name='afsn11.2.1'></a>Brug af DOM og XPath</H3>
<P CLASS="western">Her er en JSP-side, der benytter XML-funktioner
indbygget i Javas standardbibliotek til at indl&aelig;se
persongalleri.xml og lade brugeren afpr&oslash;ve forskellige
XPath-udtryk til at tr&aelig;kke information ud af filen:</P>
<P CLASS="western" ALIGN=CENTER><IMG SRC="bog12_html_m3c164f68.png" NAME="Grafik96" ALIGN=BOTTOM BORDER=0></P>
<PRE CLASS="kode-western" STYLE="">&lt;%@page import=&quot;org.w3c.dom.*,org.apache.xpath.*,javax.xml.parsers.*&quot; %&gt;
&lt;html&gt;
&lt;head&gt;&lt;title&gt;XPath-pr&oslash;ve fra Java&lt;/title&gt;&lt;/head&gt;
&lt;body&gt;

&lt;%
  String udtryk = request.getParameter(&quot;udtryk&quot;);
  if (udtryk == null) udtryk = &quot;galleri/person[@id=2]/fornavn/text()&quot;;

  try {
    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
<I>    // find filen persongalleri.xml i samme mappe som denne JSP-side</I>
    String side = application.getRealPath(request.getServletPath());
    String fil = side.substring(0, side.lastIndexOf('/')) + &quot;/persongalleri.xml&quot;;
<I>    // Fortolk XML-koden til et DOM-tr&aelig;</I>
    Document tr&aelig; = factory.newDocumentBuilder().parse(&quot;file:&quot;+<SPAN LANG="da-DK">fil</SPAN>);

<I>    // Lav liste af resultater fra XPath-udtrykket</I>
    NodeList res = XPathAPI.selectNodeList(tr&aelig;, udtryk);

    %&gt;'&lt;%= udtryk %&gt;' passer p&aring; &lt;%= res.getLength() %&gt; element(er):&lt;br&gt;&lt;%
<I>    // Genneml&oslash;b listen og udskriv</I>
    for (int i = 0; i &lt; res.getLength(); i++) {
      out.print(res.item(i).getNodeValue()+&quot;&lt;br&gt;&quot;);
    }

  } catch (Exception e) {
    e.printStackTrace();
    out.print(&quot;&lt;p&gt;Der opstod et problem: &quot;+e+&quot;&lt;/p&gt;&quot;);
  }
%&gt;

&lt;hr&gt;
Pr&oslash;v et andet XPath-udtryk
&lt;form&gt;&lt;input name=&quot;udtryk&quot; value='&lt;%= udtryk %&gt;' type=&quot;text&quot; size=&quot;70&quot;&gt;&lt;/form&gt;
f.eks.:
&lt;pre&gt;
  galleri/person[@id=2]/fornavn/text()
  //*/titel/text()
  //*/isbn/../titel/text()
  galleri/person/v&aelig;rker/v&aelig;rk[@type=&quot;bog&quot;]/titel/text()
  galleri/person/v&aelig;rker/v&aelig;rk[@type=&quot;hjemmeside&quot;]/titel/text()
&lt;/pre&gt;
Kig evt. p&aring; &lt;a href=&quot;<SPAN LANG="da-DK">persongalleri.xml&quot;&gt;XML-filen&lt;/a&gt;.</SPAN>
&lt;/body&gt;
&lt;/html&gt;</PRE>
<P CLASS="western">Ovenst&aring;ende eksempel bruger XML-funktioner,
der findes i JDK1.4. Bruger du en anden version af JDK kan det v&aelig;re
at klassen XPathAPI er ukendt. Det skal du s&aring; rette op p&aring;
ved at hente Xalan-Java fra <A CLASS="western" HREF="http://xml.apache.org/xalan-j/">http://xml.apache.org/xalan-j/</A>.</P>

<H3 CLASS="western">11.2.2 <a name='afsn11.2.2'></a>Nem generering af XML fra Java-objekter</H3>
<P CLASS="western">Javab&oslash;nner (og andre objekter med get- og
set-metoder) og almindelige objekter fra Javas standardbibliotek
(s&aring;som strenge, ArrayList, Date, ...) kan meget nemt gemmes som
XML.</P>

<P CLASS="western" STYLE="">I eksemplet Kalender.java
i <a href='kapitel9.jsp#afsn9.4.5'>afsnit 9.4.5</a> gemmer vi en ArrayList af strenge som XML:</P>
<PRE CLASS="kode-western"><I>  // gem som XML</I>
<SPAN LANG="da-DK">  XMLEncoder kal = new XMLEncoder(new FileOutputStream(&quot;kalender.xml&quot;));</SPAN>
<SPAN LANG="da-DK">  kal.writeObject(liste);</SPAN>
<SPAN LANG="da-DK">  kal.close();</SPAN></PRE><P CLASS="western">
Lige s&aring; nemt som det er at gemme objekter som XML er det at
indl&aelig;se dem igen:</P>
<PRE CLASS="kode-western"><I>  // indl&aelig;s kalenderen fra XML-fil p&aring; disken </I>
<SPAN LANG="da-DK">  XMLDecoder kal = new XMLDecoder(new FileInputStream(&quot;kalender.xml&quot;));</SPAN>
<SPAN LANG="da-DK">  liste = (ArrayList) kal.readObject();</SPAN>
<SPAN LANG="da-DK">  kal.close();</SPAN></PRE><P CLASS="western">
Kigger man i filen kalender.xml p&aring; harddisken ser man at den
indeholder</P>
<PRE CLASS="ikke-javakode-western">&lt;?xml version=&quot;1.0&quot; encoding=&quot;UTF-8&quot;?&gt;
&lt;java version=&quot;1.4.2_03&quot; class=&quot;java.beans.XMLDecoder&quot;&gt;
 &lt;object class=&quot;java.util.ArrayList&quot;&gt;
  &lt;void method=&quot;add&quot;&gt;
   &lt;string&gt;&lt;/string&gt;
  &lt;/void&gt;
  &lt;void method=&quot;add&quot;&gt;
   &lt;string&gt;Undervise&lt;/string&gt;
  &lt;/void&gt;
  &lt;void method=&quot;add&quot;&gt;
   &lt;string&gt;&lt;/string&gt;
  &lt;/void&gt;
  &lt;void method=&quot;add&quot;&gt;
   &lt;string&gt;&lt;/string&gt;
  &lt;/void&gt;
  &lt;void method=&quot;add&quot;&gt;
   &lt;string&gt;Holde fri&lt;/string&gt;
  &lt;/void&gt;
 &lt;/object&gt;
&lt;/java&gt;</PRE><P CLASS="western">
<SPAN LANG="da-DK">Bem&aelig;rk at klasserne XMLEncoder og XMLDecoder
ikke kan anvendes til at konvertere hvad som helst til og fra XML.
Specielt skal man v&aelig;re opm&aelig;rksom, hvis man &oslash;nsker
at gemme sine egne klasser: De skal v&aelig;re javab&oslash;nner og
alle data i objektet, man &oslash;nsker gemt, skal v&aelig;re
egenskaber (se <a href='kapitel9.jsp#afsn9.2.2'>afsnit 9.2.2</a>, Egenskaber p&aring; en javab&oslash;nne).</SPAN></P>
<H4 CLASS="western">Serialisering</H4>
<P CLASS="western"><SPAN LANG="da-DK">&Oslash;nsker man at gemme alle
slags objekter er <I>serialisering</I> med ObjectOutputStream og
ObjectInputStream, der f.eks. er beskrevet </SPAN>p&aring;
<A CLASS="western" HREF="http://javabog.dk/">http://javabog.dk</A> en
bedre l&oslash;sning.</P>
<PRE CLASS="kode-western"><I>  // gem som serialiseret objekt (ikke XML)</I>
  ObjectOutputStream kal = new ObjectOutputStream(
                           new FileOutputStream(&quot;kalender.ser&quot;));
  kal.writeObject(liste);
  kal.close();</PRE><P CLASS="western">
og de-serialisering:</P>
<PRE CLASS="kode-western">  kal = new ObjectInputStream(new FileInputStream(&quot;kalender.ser&quot;));
  liste = (ArrayList) kal.readObject();
  kal.close();</PRE><P CLASS="western">
Ulempen med serialisering er, at filen med de gemte objekter
(kalender.ser) er i et bin&aelig;rt format, der meget vanskeligt kan
l&aelig;ses p&aring; anden m&aring;de end ved at deserialisere det i
Java.</P>
<H2 CLASS="western">11.3 <a name='afsn11.3'></a>Syndikering (nyhedsf&oslash;dning)</SPAN></H2>
<P CLASS="western">Indholdssyndikering (eng.: content syndication)
g&aring;r kort sagt ud p&aring; at hente information (f.eks. nyheder)
fra andre hjemmesider og vise det p&aring; sin egen.</P>
<P CLASS="western">Syndikering kan give liv i en hjemmeside og
anvendes rigtig meget p&aring; n&aelig;sten alle internetportaler,
n&aring;r de p&aring; forsiden viser f.eks. vejrudsigter og nyheder
og anden information, som de ikke selv producerer, men henter fra
andre steder p&aring; nettet. 
</P>
<P CLASS="western">Syndikering forkortes RSS, der st&aring;r for
(afh&aelig;ngigt af hvem man sp&oslash;rger :-) Really Simple
Syndication, Rich Site Summary eller RDF Site Summary. Teknologien
udsprang af RDF (Resource Description Framework), et system Netscape
oprindelig introducerede. 
</P>
<H3 CLASS="western">11.3.1 <a name='afsn11.3.1'></a>Nyhedskildernes format</H3>
<P CLASS="western">Informationen fra den anden hjemmeside skal v&aelig;re
i et bestemt XML-format. For eksempel Java-nyheder fra Sun:</P>
<P ALIGN=CENTER STYLE="margin-top: 0.11cm; margin-bottom: 0.11cm"><FONT SIZE=2 STYLE="font-size: 9pt"><I><SPAN LANG="da-DK">eksempel
fra </SPAN><A CLASS="western" HREF="http://servlet.java.sun.com/syndication/rss_java_highlights.xml"><SPAN LANG="da-DK">http://servlet.java.sun.com/syndication/rss_java_highlights.xml</SPAN></A><SPAN LANG="da-DK">
p&aring; RSS-fil med nyheder</SPAN></I></FONT></P>
<PRE CLASS="ikke-javakode-western">&lt;?xml version=&quot;1.0&quot;?&gt;
<SPAN LANG="da-DK">&lt;rss version=&quot;0.91&quot;&gt;</SPAN>
<SPAN LANG="da-DK">  &lt;channel&gt;</SPAN>
<SPAN LANG="da-DK">    &lt;title&gt;java.sun.com&lt;/title&gt;</SPAN>
<SPAN LANG="da-DK">    &lt;link&gt;http://java.sun.com/&lt;/link&gt;</SPAN>
<SPAN LANG="da-DK">    &lt;description&gt;java.sun.com is the premier source of information about the Java platform.&lt;/description&gt;</SPAN>
<SPAN LANG="da-DK">    &lt;language&gt;en-us&lt;/language&gt;</SPAN>
<SPAN LANG="da-DK">    &lt;copyright&gt;Copyright: (C) 1995-2003 Sun Microsystems, Inc.&lt;/copyright&gt;</SPAN>

<SPAN LANG="da-DK">    &lt;image&gt;</SPAN>
<SPAN LANG="da-DK">      &lt;title&gt;java.sun.com&lt;/title&gt;</SPAN>
<SPAN LANG="da-DK">      &lt;url&gt;http://java.sun.com/images/v4_java_logo.gif&lt;/url&gt;</SPAN>
<SPAN LANG="da-DK">      &lt;link&gt;http://java.sun.com/&lt;/link&gt;</SPAN>
<SPAN LANG="da-DK">      &lt;width&gt;38&lt;/width&gt;</SPAN>
<SPAN LANG="da-DK">      &lt;height&gt;66&lt;/height&gt;</SPAN>
<SPAN LANG="da-DK">      &lt;description&gt;Visit java.sun.com&lt;/description&gt;</SPAN>
<SPAN LANG="da-DK">    &lt;/image&gt;</SPAN>

<SPAN LANG="da-DK">    &lt;item&gt;</SPAN>
<SPAN LANG="da-DK">      &lt;title&gt;Play Ball!&lt;/title&gt;</SPAN>
<SPAN LANG="da-DK">      &lt;link&gt;http://servlet.java.sun.com/logRedirect/rss_java_highlights/http://developer.java.sun.com/developer/technicalArticles/ThirdParty/Tendu/&lt;/link&gt;</SPAN>
<SPAN LANG="da-DK">      &lt;description&gt;Tendu's Java software applications give Major League baseball teams instant insight -- and maybe even a competitive advantage.    &lt;/description&gt;</SPAN>
<SPAN LANG="da-DK">    &lt;/item&gt;</SPAN>

<SPAN LANG="da-DK">    &lt;item&gt;</SPAN>
<SPAN LANG="da-DK">      &lt;title&gt;Toward a Global &quot;Internet of Things&quot;&lt;/title&gt;</SPAN>
<SPAN LANG="da-DK">      &lt;link&gt;http://servlet.java.sun.com/logRedirect/rss_java_highlights/http://developer.java.sun.com/developer/technicalArticles/Ecommerce/rfid/index.html&lt;/link&gt;</SPAN>
<SPAN LANG="da-DK">      &lt;description&gt;Everything you buy, consume, and enjoy--even trees!--may soon be tagged with a unique ID. Learn all about the Java technology that is propelling the Internet ever further into the physical world. &lt;/description&gt;</SPAN>
<SPAN LANG="da-DK">    &lt;/item&gt;</SPAN>
<SPAN LANG="da-DK"><I>  ... (flere &lt;item&gt;-indgange)</I></SPAN>
<SPAN LANG="da-DK">  &lt;/channel&gt;</SPAN>
<SPAN LANG="da-DK">&lt;/rss&gt;</SPAN></PRE><P CLASS="western">
Her kunne man f.eks. bruge XPath-udtrykket
'rss/channel/description/text()', for at f&aring; beskrivelsen af
nyhedskilden (der er: 'java.sun.com is the premier source of
information about the Java platform.').</P>
<P CLASS="western">Ovenst&aring;ende er RSS version 0.91. Det pr&aelig;cise
format har gennem tiden &aelig;ndret sig lidt, s&aring; p&aring;
nettet kan man finde nyhedskilder i RSS-format version 0.91, 0.92,
1.0 og 2.0. De enkelte versioner adskiller sig ikke meget fra
hinanden, men DOM-tr&aelig;erne kan v&aelig;re lidt forskellige, s&aring;
man skal lige tjekke om nyhederne kommer korrekt over p&aring; ens
egen side.</P>
<P CLASS="western" STYLE="">Her er et
eksempel p&aring; en RSS-fil version 1.0 med nyheder fra Danmark
Radio:</P>
<P ALIGN=CENTER STYLE="margin-top: 0.11cm; margin-bottom: 0.11cm"><FONT SIZE=2 STYLE="font-size: 9pt"><I><SPAN LANG="da-DK">eksempel
fra </SPAN><A CLASS="western" HREF="http://www.dr.dk/nyheder/html/nyheder/rss/"><SPAN LANG="da-DK">http://www.dr.dk/nyheder/html/nyheder/rss/</SPAN></A><SPAN LANG="da-DK">
p&aring; RSS-fil version 1.0 (nogle af indgange er fjernet)</SPAN></I></FONT></P>
<PRE CLASS="ikke-javakode-western">&lt;?xml version=&quot;1.0&quot; encoding=&quot;iso-8859-1&quot;?&gt;
<SPAN LANG="da-DK">&lt;rdf:RDF xmlns:rdf=&quot;http://www.w3.org/1999/02/22-rdf-syntax-ns#&quot;</SPAN>
<SPAN LANG="da-DK">         xmlns=&quot;http://purl.org/rss/1.0/&quot;</SPAN>
<SPAN LANG="da-DK">         xmlns:dc=&quot;http://purl.org/dc/elements/1.1/&quot;</SPAN>
<SPAN LANG="da-DK">         xmlns:taxo=&quot;http://purl.org/rss/1.0/modules/taxonomy/&quot;</SPAN>
<SPAN LANG="da-DK">         xmlns:syn=&quot;http://purl.org/rss/1.0/modules/syndication/&quot;&gt;</SPAN>

<SPAN LANG="da-DK">&lt;channel rdf:about=&quot;http://www.dr.dk/nyheder/&quot;&gt;</SPAN>
<SPAN LANG="da-DK">&lt;title&gt;DR Nyheder Online&lt;/title&gt;</SPAN>
<SPAN LANG="da-DK">&lt;link&gt;http://www.dr.dk/nyheder/&lt;/link&gt;</SPAN>
<SPAN LANG="da-DK">&lt;description&gt;Velkommen til DR Nyheder p&aring; nettet: Nyheder opdateret 24 timer i d&oslash;gnet. &copy; DR 2003&lt;/description&gt;</SPAN>
<SPAN LANG="da-DK">&lt;dc:language&gt;da&lt;/dc:language&gt;</SPAN>
<SPAN LANG="da-DK">&lt;items&gt;&lt;rdf:Seq&gt;  </SPAN>
<FONT SIZE=1><SPAN LANG="da-DK"> &lt;rdf:li rdf:resource=&quot;http://www.dr.dk/nyheder/indland/article.jhtml?articleID=194577&quot; /&gt; </SPAN></FONT>
<FONT SIZE=1><SPAN LANG="da-DK"> &lt;rdf:li rdf:resource=&quot;http://www.dr.dk/nyheder/indland/article.jhtml?articleID=194567&quot; /&gt; </SPAN></FONT>
<FONT SIZE=1><SPAN LANG="da-DK"> &lt;rdf:li rdf:resource=&quot;http://www.dr.dk/nyheder/udland/article.jhtml?articleID=194574&quot; /&gt; </SPAN></FONT>
<FONT SIZE=1><SPAN LANG="da-DK"> &lt;rdf:li rdf:resource=&quot;http://www.dr.dk/nyheder/indland/article.jhtml?articleID=194569&quot; /&gt; </SPAN></FONT>
<FONT SIZE=1><SPAN LANG="da-DK"> &lt;rdf:li rdf:resource=&quot;http://www.dr.dk/nyheder/indland/article.jhtml?articleID=194553&quot; /&gt; </SPAN></FONT>
<SPAN LANG="da-DK">&lt;/rdf:Seq&gt;&lt;/items&gt;</SPAN>
<SPAN LANG="da-DK">    </SPAN>
<SPAN LANG="da-DK">&lt;item rdf:about=&quot;http://www.dr.dk/nyheder/indland/article.jhtml?articleID=194577&quot;&gt;</SPAN>
<SPAN LANG="da-DK"> &lt;title&gt;L&aelig;ger truer med sygehusstrejke&lt;/title&gt;</SPAN>
<SPAN LANG="da-DK"> &lt;link&gt;http://www.dr.dk/nyheder/indland/article.jhtml?articleID=194577&lt;/link&gt;</SPAN>
<SPAN LANG="da-DK"> &lt;description&gt;En alvorlig konflikt truer med at lamme dele af det vestsj&aelig;llandske sundhedsv&aelig;sen, efter at 70 ledende medarbejdere p&aring; tre sygehuse i Vestsj&aelig;llands Amt har klaget til amtspolitikerne over to medicinske chefer.&lt;/description&gt;</SPAN>
<SPAN LANG="da-DK">&lt;/item&gt;</SPAN>
<SPAN LANG="da-DK">      </SPAN>
<SPAN LANG="da-DK">&lt;item rdf:about=&quot;http://www.dr.dk/nyheder/indland/article.jhtml?articleID=194567&quot;&gt;</SPAN>
<SPAN LANG="da-DK"> &lt;title&gt;Sverige - et smuthul for tvangs&aelig;gteskaber&lt;/title&gt;</SPAN>
<SPAN LANG="da-DK"> &lt;link&gt;http://www.dr.dk/nyheder/indland/article.jhtml?articleID=194567&lt;/link&gt;</SPAN>
<SPAN LANG="da-DK"> &lt;description&gt;Hver m&aring;ned flytter mellem 48 og 64 unge nydanskere til Sverige for at blive familiesammenf&oslash;rt med en borger fra et ikke-EU-land, som de p&aring; grund af den danske 24-&aring;rs-regel ikke kan blive sammenf&oslash;rt med i Danmark. Siden vender de tilbage til Danmark.&lt;/description&gt;</SPAN>
<SPAN LANG="da-DK">&lt;/item&gt;</SPAN>
<SPAN LANG="da-DK">      </SPAN>
<SPAN LANG="da-DK">&lt;item rdf:about=&quot;http://www.dr.dk/nyheder/udland/article.jhtml?articleID=194574&quot;&gt;</SPAN>
<SPAN LANG="da-DK"> &lt;title&gt;To franske journalister gidsler i Irak&lt;/title&gt;</SPAN>
<SPAN LANG="da-DK"> &lt;link&gt;http://www.dr.dk/nyheder/udland/article.jhtml?articleID=194574&lt;/link&gt;</SPAN>
<SPAN LANG="da-DK"> &lt;description&gt;Irakiske bortf&oslash;rere har givet Frankrig 48 timer til at g&aring; ind p&aring; deres krav, hvis de skal sk&aring;ne to franske journalister, som blev bortf&oslash;rt forleden. Bortf&oslash;rerne kr&aelig;ver, at Frankrig oph&aelig;ver loven fra for&aring;ret, der forbyder muslimske piger at b&aelig;re hovedt&oslash;rkl&aelig;de i franske skoler.&lt;/description&gt;</SPAN>
<SPAN LANG="da-DK">&lt;/item&gt;</SPAN>
<SPAN LANG="da-DK">      </SPAN>
<SPAN LANG="da-DK">&lt;item rdf:about=&quot;http://www.dr.dk/nyheder/indland/article.jhtml?articleID=194569&quot;&gt;</SPAN>
<SPAN LANG="da-DK"> &lt;title&gt;Advarsel mod s&oslash;d yoghurtdrik&lt;/title&gt;</SPAN>
<SPAN LANG="da-DK"> &lt;link&gt;http://www.dr.dk/nyheder/indland/article.jhtml?articleID=194569&lt;/link&gt;</SPAN>
<SPAN LANG="da-DK"> &lt;description&gt;Ern&aelig;ringseksperter advarer mod Arlas s&oslash;de yoghurtdrik Cultura, som de kalder for slik forkl&aelig;dt som yoghurtdrik, fordi drikken indeholder n&aelig;sten lige s&aring; meget sukker som sodavand. Topscoreren er vaniljedrik, der indeholder svarende til 21 sukkerknalder.&lt;/description&gt;</SPAN>
<SPAN LANG="da-DK">&lt;/item&gt;</SPAN>

<SPAN LANG="da-DK">&lt;/rdf:RDF&gt;</SPAN></PRE><P CLASS="western">
<SPAN LANG="da-DK">Sammenligner man ovenst&aring;ende med eksemplet
med Java-nyheder, ser man at DOM-tr&aelig;et er lidt anderledes. Man
skal f.eks. bruge 'RDF/channel/description/text()' som XPath-udtryk
(med RDF i stedet for rss) for at f&aring; beskrivelsen ('Nyheder
Danmarks Radio')<A CLASS="sdfootnoteanc" NAME="sdfootnote1anc" HREF="#sdfootnote1sym"><SUP>1</SUP></A>.
</SPAN>
</P>

<H3 CLASS="western">11.3.2 <a name='afsn11.3.2'></a>Fremvisning med RSS-taglib</H3>
<P CLASS="western">Lad os nu se p&aring;, hvordan man kan indflette
andres nyheder i sine egne sider. 
</P>
<P CLASS="western"><SPAN LANG="da-DK">Hvis man ikke har mod p&aring;
selv at skrive koden, der henter og behandler XML-filerne kan m</SPAN>an
p&aring;
<A CLASS="western" HREF="http://java.sun.com/developer/technicalArticles/javaserverpages/rss_utilities/">http://java.sun.com/developer/technicalArticles/javaserverpages/rss_utilities/</A>
 f&aring; et J<SPAN LANG="da-DK">SP taglib-bibliotek der tillader
RSS-f&oslash;dning </SPAN>(af kilder med RSS version 0.91, 0.92 og
2.0) <SPAN LANG="da-DK">til en webside. Et tag library (forkortet
taglib) er, som navnet antyder, et bibliotek af HTML-lignende koder.
Ligesom JSP-koderne udf&oslash;res disse p&aring; serveren, s&aring;dan
at klienten aldrig ser dem.</SPAN></P>
<P CLASS="western">P&aring; hjemmesiden er ogs&aring; beskrevet,
hvordan taglib-biblioteket installeres. Dette er en rimelig nem
procedure: Hent ZIP-filen, l&aelig;g rssutils.jar ind i WEB-INF/lib/
i webapplikationen og rssutils.tld ind i WEB-INF/.</P>
<P CLASS="western">Herunder er et simpelt eksempel p&aring; brug af
RSS-taglibbet:</P>
<PRE CLASS="kode-western"><B>&lt;%@ taglib uri=&quot;/WEB-INF/rssutils.tld&quot; prefix=&quot;rss&quot; %&gt;</B>
<SPAN LANG="da-DK">&lt;html&gt;</SPAN>
<SPAN LANG="da-DK">&lt;head&gt;&lt;title&gt;Syndikering med RSS-taglib&lt;/title&gt;&lt;/head&gt;</SPAN>
<SPAN LANG="da-DK">&lt;body&gt;</SPAN>

<SPAN LANG="da-DK">&lt;h1&gt;Java-nyheder&lt;/h1&gt;</SPAN>
<SPAN LANG="da-DK">&lt;rss:feed feedId=&quot;nyh&quot;</SPAN>
<SPAN LANG="da-DK">          url=&quot;http://servlet.java.sun.com/syndication/rss_java_highlights.xml&quot; /&gt;</SPAN>

<SPAN LANG="da-DK">&lt;rss:forEachItem feedId=&quot;nyh&quot;&gt;</SPAN>
<SPAN LANG="da-DK">  &lt;a href='&lt;rss:itemLink feedId=&quot;nyh&quot;/&gt;'&gt;&lt;rss:itemTitle feedId=&quot;nyh&quot;/&gt;&lt;/a&gt;&amp;nbsp;</SPAN>
<SPAN LANG="da-DK">  &lt;font size=&quot;-1&quot;&gt;</SPAN>
<SPAN LANG="da-DK">    &lt;rss:itemDescription feedId=&quot;nyh&quot;/&gt;</SPAN>
<SPAN LANG="da-DK">  &lt;/font&gt;&lt;br&gt;</SPAN>
<SPAN LANG="da-DK">&lt;/rss:forEachItem&gt;</SPAN>
<SPAN LANG="da-DK">Kilde:&lt;rss:channelTitle feedId=&quot;nyh&quot;/&gt;&lt;br&gt;</SPAN>

<SPAN LANG="da-DK">&lt;h1&gt;Tr&aring;dl&oslash;se nyheder&lt;/h1&gt;</SPAN>
<SPAN LANG="da-DK">&lt;rss:feed feedId=&quot;traadl&quot; </SPAN>
<SPAN LANG="da-DK">      url=&quot;http://servlet.java.sun.com/syndication/rss_wireless_highlights.xml&quot; /&gt;</SPAN>
<SPAN LANG="da-DK">&lt;rss:forEachItem feedId=&quot;traadl&quot;&gt;</SPAN>
<SPAN LANG="da-DK">  &lt;rss:itemTitle feedId=&quot;traadl&quot;/&gt;</SPAN>
<SPAN LANG="da-DK">   (&lt;a href='&lt;rss:itemLink feedId=&quot;traadl&quot;/&gt;'&gt;l&aelig;s mere&lt;/a&gt;)&lt;br&gt;</SPAN>
<SPAN LANG="da-DK">&lt;/rss:forEachItem&gt;</SPAN>

<SPAN LANG="da-DK">&lt;/body&gt;</SPAN>
<SPAN LANG="da-DK">&lt;/html&gt;</SPAN></PRE>
<P CLASS="western">Denne side producerer f&oslash;lgende
sk&aelig;rmbillede, med nyheder fra to nyhedskilder (Java-nyheder og
nyheder om tr&aring;dl&oslash;se apparater) pr&aelig;senteret lidt
forskelligt neden under:</P>
<P CLASS="western" ALIGN=CENTER><IMG SRC="bog12_html_52447d00.png" NAME="Grafik12" ALIGN=BOTTOM BORDER=0></P>

<H3 CLASS="western">11.3.3 <a name='afsn11.3.3'></a>Fremvisning med Java</H3>
<P CLASS="western">Har du mod p&aring; selv at arbejde med XML, kan
du benytte Javas indbyggede funktioner til at udv&aelig;lge
informationer fra en RSS-nyhedkilde med XPath og flette dem ind i
dine sider.</P>
<P CLASS="western">Det f&oslash;lgende eksempel fletter nyheder fra
Danmarks Radio ind i siden:</P>
<P CLASS="western" ALIGN=CENTER><IMG SRC="bog12_html_4293ab08.png" NAME="Grafik98" ALIGN=BOTTOM BORDER=0></P>
<PRE CLASS="kode-western" STYLE="">&lt;%@page import=&quot;org.w3c.dom.*,org.apache.xpath.*,javax.xml.parsers.*&quot; %&gt;
&lt;html&gt;
&lt;head&gt;&lt;title&gt;Syndikering med Java&lt;/title&gt;&lt;/head&gt;
&lt;body&gt;

&lt;%
  String kilde = request.getParameter(&quot;kilde&quot;);
  if (kilde == null) kilde = &quot;http://www.dr.dk/nyheder/html/nyheder/rss/&quot;;

  try {
    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
<I>    // Fortolk kildens XML-kode til et DOM-tr&aelig;</I>
    Document tr&aelig; = factory.newDocumentBuilder().parse(kilde);

<I>    // Find titlen p&aring; nyhedskilden med XPath-udtryk</I>
    Node titel = XPathAPI.selectSingleNode(tr&aelig;, &quot;RDF/channel/title/text()&quot;);
  %&gt;

<SPAN LANG="da-DK">&lt;h1&gt;Nyheder fra &lt;%= titel.getNodeValue() %&gt;&lt;/h1&gt;</SPAN>
&lt;a href=&quot;&lt;%= kilde %&gt;&quot; type=&quot;application/rss+xml&quot;&gt;RSS-kilde&lt;/a&gt; til disse nyheder.
&lt;p&gt;
  &lt;%
<I>    // Lav liste med overskrifter p&aring; artikler med XPath-udtryk</I>
    NodeList overskrifter = XPathAPI.selectNodeList(tr&aelig;, &quot;RDF/item/title/text()&quot;);

<I>    // Lav liste over henvisninger til mere l&aelig;sninger med XPath-udtryk</I>
    NodeList henvisninger = XPathAPI.selectNodeList(tr&aelig;, &quot;RDF/item/link/text()&quot;);

<I>    // Genneml&oslash;b listerne og udskriv dem</I>
    for (int i = 0; i &lt; overskrifter.getLength(); i++) {
      out.print(overskrifter.item(i).getNodeValue());
      out.print(&quot; &lt;a href=&quot;+henvisninger.item(i).getNodeValue()+&quot;&gt;mere&lt;/a&gt;&lt;br&gt;&quot;);
    }
<IMG SRC="bog12_html_m7903f24f.png" NAME="Grafik97" ALIGN=RIGHT BORDER=0>
  } catch (Exception e) {
    e.printStackTrace();
    out.print(&quot;Et problem opstod: &quot;+e);
  }
%&gt;


&lt;p&gt;
Pr&oslash;v en anden nyhedskilde

&lt;form&gt;
&lt;input type=&quot;text&quot; name=&quot;kilde&quot; 
 value=&quot;http://slashdot.org/index.rss&quot; 
 size=&quot;40&quot;&gt;
&lt;/form&gt; 

&lt;/body&gt;
&lt;/html&gt;</PRE>
<P CLASS="western"><BR><BR>Eksemplet tillader at man kan &aelig;ndre
nyhedskilde. P&aring; billedet til h&oslash;jre hentes nyhederne i
stedet fra Slashdot (der leverer nyheder for n&oslash;rder).</P>
<H3 CLASS="western" STYLE="">11.3.4 <a name='afsn11.3.4'></a>Syndikering
med JSTL</H3>
<P CLASS="western"><SPAN LANG="da-DK">Man kan ogs&aring; udnytte JSTL
til syndikering. I <a href='kapitel6.jsp#afsn6.4.1'>afsnit 6.4.1</a> vises et eksempel, der indfletter
nyheder fra Danmarks Radio ved hj&aelig;lp af JSTLs XML-funktioner:</SPAN></P>
<P CLASS="western" ALIGN=CENTER><IMG SRC="bog12_html_m52b0733d.png" NAME="Grafik99" ALIGN=BOTTOM BORDER=0></P>
<P CLASS="western"><SPAN LANG="da-DK">I <a href='kapitel6.jsp#afsn6.4.2'>afsnit 6.4.2</a> er ogs&aring;
n&aelig;vnt lidt om caching af nyhedskilder, som er relevant at
overveje, hvis man for alvor vil g&oslash;re brug af syndikering.</SPAN></P>

<P CLASS="western"><SPAN LANG="da-DK">XPath-udtrykkene i <a href='kapitel6.jsp#afsn6.4.1'>afsnit 6.4.1</a>
er desv&aelig;rre lidt knudrede</SPAN>:</P>
<PRE CLASS="kode-western">  &lt;x:out select=&quot;$rss//*[name()='channel']/*[name()='title'][1]&quot;/&gt;</PRE><P CLASS="western">
Det skyldes at JSTLs XML-behandling endnu <SPAN LANG="da-DK">ikke
fuldt underst&oslash;tter brug af namespaces, som RSS version 1.0
benytter (det er de mange xmlns:-koder i toppen af DRs RSS-fil).</SPAN></P>
<P CLASS="western">Det kunne egentlig v&aelig;re skrevet s&aring;
enkelt som (RSS 1.0):</P>
<PRE CLASS="kode-western">  &lt;x:out select=&quot;$rss/RDF/channel/title/text()&quot;/&gt;</PRE><P CLASS="western">
eller (RSS 0.91, hvor DOM-tr&aelig;ets rod hedder rss og ikke RDF):</P>
<PRE CLASS="kode-western">  &lt;x:out select=&quot;$rss/<SPAN LANG="da-DK"><B>rss</B>/channel/title/text()</SPAN>&quot;/&gt;</PRE><P CLASS="western">
En fordel ved de knudrede XPath-udtryk er dog, at de faktisk fungerer
for alle RSS-versionerne, uanset om hele molevitten nu engang ligger
under 'RDF' eller 'rss' i DOM-tr&aelig;et.</P>
<H3 CLASS="western">11.3.5 <a name='afsn11.3.5'></a>Mere information og nyhedskilder p&aring;
nettet</H3>
<P CLASS="western"><SPAN LANG="da-DK">Se
</SPAN><A CLASS="western" HREF="http://www-106.ibm.com/developerworks/java/library/j-jstl0520"><SPAN LANG="da-DK">http://www-106.ibm.com/developerworks/java/library/j-jstl0520</SPAN></A><SPAN LANG="da-DK">
for mere information om brug af JSTL til RSS-syndikering.</SPAN></P>
<P CLASS="western"><SPAN LANG="da-DK">Using RSS in JSP pages:
</SPAN><A CLASS="western" HREF="http://today.java.net/pub/a/today/2003/08/08/rss.html"><SPAN LANG="da-DK">http://today.java.net/pub/a/today/2003/08/08/rss.html</SPAN></A><SPAN LANG="da-DK">
</SPAN>
</P>

<P CLASS="western">Der findes utallige nyhedskilder p&aring; nettet,
og der kommer dagligt flere til.</P>
<P CLASS="western"><SPAN LANG="da-DK">Ofte vil et websted vise et
lille XML-ikon nederst p&aring; siden for at g&oslash;re opm&aelig;rksom
p&aring; at dens indhold kan syndikeres. Det ser s&aring;dan her ud:
<IMG SRC="bog12_html_427d37b7.gif" NAME="Grafik32" ALIGN=BOTTOM BORDER=0>.</SPAN></P>
<P CLASS="western">Her er et par websteder med RSS og URLen til deres
nyhedsf&oslash;dning:</P>
<UL>
  <LI><P CLASS="western"><SPAN LANG="da-DK">DR Nyheder:
  </SPAN><A CLASS="western" HREF="http://www.dr.dk/nyheder/html/nyheder/rss/"><SPAN LANG="da-DK">http://www.dr.dk/nyheder/html/nyheder/rss/</SPAN></A></P>
  <LI><P CLASS="western"><SPAN LANG="da-DK">Dagbladet Information
  </SPAN><A CLASS="western" HREF="http://rss.asdf.dk/information.rss"><SPAN LANG="da-DK">http://rss.asdf.dk/information.rss</SPAN></A><SPAN LANG="da-DK">
  </SPAN>
  </P>
  <LI><P CLASS="western"><SPAN LANG="da-DK">Alt Om K&oslash;benhavn:
  </SPAN><A CLASS="western" HREF="http://rss.asdf.dk/aok.rss"><SPAN LANG="da-DK">http://rss.asdf.dk/aok.rss</SPAN></A></P>
  <LI><P CLASS="western"><SPAN LANG="da-DK">B&oslash;rsen Online:
  </SPAN><A CLASS="western" HREF="http://rss.asdf.dk/borsen.rss"><SPAN LANG="da-DK">http://rss.asdf.dk/borsen.rss</SPAN></A></P>
  <LI><P CLASS="western"><SPAN LANG="da-DK">Slashdot:
  </SPAN><A CLASS="western" HREF="http://slashdot.org/slashdot.rdf"><SPAN LANG="da-DK">http://slashdot.org/slashdot.rdf</SPAN></A><SPAN LANG="da-DK">
  </SPAN>
  </P>
  <LI><P CLASS="western"><SPAN LANG="da-DK">Java-nyheder:
  </SPAN><A CLASS="western" HREF="http://servlet.java.sun.com/syndication/rss_java_highlights.xml"><SPAN LANG="da-DK">http://servlet.java.sun.com/syndication/rss_java_highlights.xml</SPAN></A><SPAN LANG="da-DK">
  </SPAN>
  </P>
  <LI><P CLASS="western"><SPAN LANG="da-DK">Tr&aring;dl&oslash;s Java:
  </SPAN><A CLASS="western" HREF="http://servlet.java.sun.com/syndication/rss_wireless_highlights.xml"><SPAN LANG="da-DK">http://servlet.java.sun.com/syndication/rss_wireless_highlights.xml</SPAN></A><SPAN LANG="da-DK">
  </SPAN>
  </P>
</UL>
<P CLASS="western">Her er et par steder, der holder styr p&aring; de
danske websteder med RSS-f&oslash;dning:</P>
<UL>
  <LI><P CLASS="western"><A CLASS="western" HREF="http://rss.spontek.dk/"><SPAN LANG="da-DK">http://rss.spontek.dk</SPAN></A><SPAN LANG="da-DK">
  </SPAN>
  </P>
  <LI><P CLASS="western"><A CLASS="western" HREF="http://rss.asdf.dk/"><SPAN LANG="da-DK">http://rss.asdf.dk</SPAN></A><SPAN LANG="da-DK">
  </SPAN>
  </P>
</UL>

<H2 CLASS="western" STYLE="">11.4 <a name='afsn11.4'></a>Principper
i metodekald over netv&aelig;rk</SPAN></H2>
<P CLASS="western">I dette afsnit vil vi beskrive en <SPAN LANG="da-DK">m&aring;de
at arbejde med objekter, der eksisterer p&aring; en anden fysisk
maskine, <I>som om de var lokale objekter</I>.</SPAN></P>
<P CLASS="western">Herunder er tegnet, hvad der sker, n&aring;r en
klient p&aring; maskine A laver et metodekald i et <I>serverobjekt</I>
(da: v&aelig;rts-objekt), der befinder sig p&aring; maskine B:</P>
<P CLASS="western"><IMG SRC="bog12_html_m12850798.gif" NAME="Objekt4" ALIGN=MIDDLE></P>

<P CLASS="western"><SPAN LANG="da-DK">Serverobjektet findes slet ikke
p&aring; maskine A, i stedet er der en s&aring;kaldt <I>stub</I>, et
proxy-objekt, der repr&aelig;senterer det rigtige objekt p&aring;
serveren. </SPAN>
</P>
<P CLASS="western">N&aring;r der sker et kald til stubben p&aring;
maskine A, s&oslash;rger den for at transportere kaldet og alle
parametre til maskine B, hvor serverobjektet bliver kaldt, som om det
var et lokalt kald. Serverobjektets svar bliver transporteret tilbage
til stubben, der returnerer svaret til klienten.</P>
<P CLASS="western">Denne proces foreg&aring;r helt automatisk og er
usynlig for klienten s&aring;vel som serverobjektet. 
</P>
<P CLASS="western">For at kunne transportere parametre og returv&aelig;rdi
mellem maskinerne, skal alle data, der sendes over netv&aelig;rket,
kunne oms&aelig;ttes til en r&aelig;kke byte af systemet
('serialiseres').</P>

<H3 CLASS="western">11.4.1 <a name='afsn11.4.1'></a>Systemer til <SPAN LANG="da-DK">metodekald
over netv&aelig;rk</SPAN></H3>
<P CLASS="western">I dag findes der mange m&aring;der, hvorp&aring;
man kan lave systemer, der kan h&aring;ndtere program-til-program
kommunikation, bl.a. RMI, EJB, webtjenester, CORBA eller DCOM. 
</P>
<P CLASS="western">Det er ovenst&aring;ende princip, der bruges i
alle disse systemer.</P>

<UL>
  <LI><P CLASS="western" STYLE=""><SPAN LANG="da-DK">RMI,
  Remote Method Invocation er meget nemt at benytte. Det bygger p&aring;
  Java, s&aring; b&aring;de klientdel og serverdel skal skrives i
  Java. RMI benytter Java-serialisering (der er et bin&aelig;rt
  format), n&aring;r det sender data mellem klient og server. Man kan
  ikke forvente, at kunne kalde metoder i et RMI-objekt uden for
  lokalnettet, da RMI benytter andre porte end HTTP-protokollen
  (n&aelig;sten alle </SPAN>firewalls har &aring;bnen p&aring; port
  80, som HTTP-protokollen benytter sig af).</P>
  <LI><P CLASS="western">CORBA, Common Object Request Broker
  Architecture, er sproguafh&aelig;ngig (s&aring; objekterne beh&oslash;ves
  ikke skrives i Java), men er sv&aelig;rt at bruge, der skal
  genereres et v&aelig;ld af filer og CORBAs beskrivelse af
  fjernobjekternes metoder, IDL (Interface Definition Language), er
  sv&aelig;rt at forst&aring;<SPAN LANG="da-DK">.</SPAN></P>
  <LI><P CLASS="western">EJB, Enterprise JavaBeans, der er beskrevet i
  <a href='kapitel12.jsp'>kapitel 12</a>, benytter RMI eller CORBA.</P>
  <LI><P CLASS="western"><SPAN LANG="da-DK">Webtjenester, beskrevet i
  n&aelig;ste afsnit, </SPAN>er sprog- og platformsuafh&aelig;ngigt,
  benytter XML i stedet for bin&aelig;re protokoller og kan benytte
  HTTP-protokollen til at transportere metodekald (s&aring;
  kommunikationen slipper igennem firewalls).</P>
  <LI><P CLASS="western"><SPAN LANG="da-DK">DCOM, Distributed Common
  Object Model, er Microsofts m&aring;de at kommunikere fra et program
  til et andet. Selvom programmeringssprogene kan variere, er det kun
  programmeringssprog, der er kompatible p&aring; en
  Microsoft-platform, der kan benyttes, s&aring;som Visual Basic, C++
  osv. Det samme g&aelig;lder for klientprogrammerne, der ogs&aring;
  skal ligge p&aring; Microsoft-platforme.</SPAN></P>
</UL>

<H2 CLASS="western">11.5 <a name='afsn11.5'></a>Webtjenester</SPAN></H2>
<P CLASS="western"><SPAN LANG="da-DK">Webtjenester (eng.: Web
services) s&aring; dagens lys f&oslash;rste gang i starten af 2002 og
er udviklet af Sun Microsystems, da de lancerede deres f&oslash;rste
udgave af Java Web Services Developer's Pack (JWSDP).</SPAN></P>
<P CLASS="western"><SPAN LANG="da-DK">En webtjeneste er et system til
program-til-program kommunikation p&aring; tv&aelig;rs af netv&aelig;rk.
Man kommunikerer med en webtjeneste<FONT COLOR="#0000ff"> </FONT>ved
at sende og modtage SOAP-meddelelser (XML-dokumenter, se senere), som
skal overholde det format, der er fastlagt i beskrivelsen af
webtjenesten (WSDL, se senere). SOAP-meddelelserne overf&oslash;res
typisk med HTTP-protokollen. Webtjenester kan v&aelig;re registreret
offentligt (UDDI, se senere).</SPAN></P>

<H3 CLASS="western">11.5.1 <a name='afsn11.5.1'></a>SOAP - kommunikation med webtjenesten</H3>
<P CLASS="western">Kommunikationen mellem en klient og en webtjeneste
foreg&aring;r med SOAP (Simple Object Access Protocol), hvor
meddelelserne mellem klient og server er sm&aring; XML-dokumenter i
bestemt format.</P>
<P CLASS="western">SOAP er hverken system- eller
programmeringssprogsafh&aelig;ngigt: B&aring;de webtjenesterne og de
klienter, der bruger dem, kan skrives p&aring; alle mulige platforme
s&aring;som Linux, Mac eller Windows og med forskellige
programmeringssprog s&aring;som Java, C++, Perl, Python, ASP eller
PHP. En webtjeneste og de tilh&oslash;rende klienter beh&oslash;ver
ikke at v&aelig;re skrevet i det samme programmeringssprog, s&aring;
l&aelig;nge kommunikationen mellem dem overholder den struktur, der
er beskrevet i webtjenestens WSDL.</P>

<H3 CLASS="western">11.5.2 <a name='afsn11.5.2'></a>WSDL - beskrivelsen af <SPAN LANG="da-DK">webtjenesten</SPAN></H3>
<P CLASS="western">WSDL st&aring;r for Web Service Definition
Language. Det er et XML-dokument, der beskriver en webtjeneste i
detaljer. I WSDLen til en webtjeneste kan man se webtjenestens URL - 
den adresse, hvor webtjenesten udbydes, hvilke metoder webtjenesten
stiller til r&aring;dighed, hvilke parametre, som webtjenestens
metoder tager i en foresp&oslash;rgsel og hvilke parametre
webtjeneste svarer tilbage med p&aring; en foresp&oslash;rgsel.</P>
<P CLASS="western">Hvis man vil danne sine egne stubbe til at tilg&aring;
en webtjeneste, skal man have fat i webtjenestens WSDL, s&aring; man
kan se, hvad metoderne hedder, og hvordan de skal foresp&oslash;rges.
</P>
<P CLASS="western"><SPAN LANG="da-DK">Der findes mange programmer,
der automatisk kan danne stubbene ud fra et WSDL. Hvordan man g&oslash;r
i Oracle JDeveloper og Apache Axis er omtalt i <a href='kapitel11.jsp#afsn11.5.5'>afsnit 11.5.5</a>, Genere Java-API fra webtjeneste (WSDL).</SPAN></P>

<H3 CLASS="western">11.5.3 <a name='afsn11.5.3'></a>UDDI - offentlige lister over webtjenester</H3>
<P CLASS="western">Skal man udgive sin webtjeneste til offentlig
brug, kan det v&aelig;re smart at udgive den i en slags telefonbog,
som De Gule Sider. Brugere kan sl&aring; op i denne 'telefonbog' for
at finde en tjeneste, der d&aelig;kker deres behov. Her kan de finde
URLen p&aring; webtjenesten, webtjenestens WSDL og en beskrivelse af,
hvad webtjenesten kan g&oslash;re for dem. Der er et par af de store
IT-firmaer, der stiller en s&aring;dan telefonbog til r&aring;dighed
blandt andet Microsoft og IBM. 
</P>
<P CLASS="western"><SPAN LANG="da-DK">F.eks. kan man finde de
webtjenester, som internet-boghandlen Amazon stiller til
r&aring;dighed,&nbsp;</SPAN>p&aring;:&nbsp;<A CLASS="western" HREF="https://uddi.ibm.com/ubr/findservice?action=details&amp;servicekey=BA6D9D56-EA3F-4263-A95A-EEB17E5910DB">https://uddi.ibm.com/ubr/findservice?action=details&amp;servicekey=BA6D9D56-EA3F-4263-A95A-EEB17E5910DB</A>.
</P>
<P CLASS="western">En s&aring;dan<SPAN LANG="da-DK"> telefonbog over
webtjenester kaldes for UDDI, som st&aring;r for Universal
Description and Discovery Integration. Fordelen ved at f&aring;
listet sine webtjenester i UDDIerne er at de bliver kendt et sted,
hvor brugerne ved, de skal kigge efter dem.</SPAN></P>
<H4 CLASS="western">&Oslash;velse</H4>
<P CLASS="western">G&aring; ind p&aring; UDDI-siden
<A CLASS="western" HREF="http://uddi.xmethods.net/">http://uddi.xmethods.net/</A>
og l&aelig;s om de forskellige webtjenester.</P>
<P CLASS="western">P&aring; siden er ogs&aring; en gr&aelig;nseflade,
som kan bruges til at pr&oslash;ve at kalde nogle af webtjenesterne.
Pr&oslash;v ogs&aring; den.</P>

<H3 CLASS="western">11.5.4 <a name='afsn11.5.4'></a>Bruge Googles webtjenester til s&oslash;gninger</H3>
<P CLASS="western">Google har en webtjeneste, som tillader udviklere
at skrive programmer, der kan s&oslash;ge i de milliarder af
dokumenter, som Google indekserer.</P>
<P CLASS="western"><SPAN LANG="da-DK">G&aring; ind p&aring;
</SPAN><A CLASS="western" HREF="http://google.com/apis"><SPAN LANG="da-DK">http://google.com/apis</SPAN></A><SPAN LANG="da-DK">
og l&aelig;s om Google Web APIs og hent udviklingskittet.</SPAN></P>
<P CLASS="western">Du skal ogs&aring; bruge en n&oslash;gle, som du
kan f&aring; ved at registrere dig. N&oslash;glen er en lang streng
som f.eks.: VkjZ2P5QFHICg5MfvjuwzmJm1T/iYbdY</P>
<P CLASS="western">Det letteste er at bruge Googles
Java-programmeringsgr&aelig;nseflade (API) til webtjenesten.<BR>Pak
filen ud og pr&oslash;v demoen, der ligger i googleapi.jar. Pr&oslash;v
f.eks. fra kommandolinjen at s&oslash;ge p&aring; &quot;Den lille
havfrue&quot; (skriv p&aring; en enkelt linje - husk at udskifte med
din egen n&oslash;gle):</P>
<PRE CLASS="western">java -cp googleapi.jar com.google.soap.search.GoogleAPIDemo
<SPAN LANG="da-DK">  VKjZ2P5QFHICg5MfvjuwzmJm1T/iYbdY search &quot;Den lille havfrue&quot;</SPAN></PRE><P CLASS="western">
<BR>Ud skulle gerne komme en masse adresser p&aring; sider om den
lille havfrue, f.eks.:</P>
<PRE CLASS="ikke-javakode-western">Parameters:
Client key = <SPAN LANG="da-DK">VkjZ2P5QFHICg5MfvjuwzmJm1T/iYbdY</SPAN>
Directive  = search
Args       = Den lille havfrue
Google Search Results:
======================
{
TM = 0.367159
Q  = &quot;Den lille havfrue&quot;
Start Index = 1
End   Index = 10
Estimated Total Results Number = 7590
Rs =
  {
  [
  URL  = &quot;http://hjem.get2net.dk/OSJ_INDEX/hybenrose/havfruen/&quot;
  Title = &quot;&lt;b&gt;Den&lt;/b&gt; &lt;b&gt;lille&lt;/b&gt; &lt;b&gt;Havfrue&lt;/b&gt;&quot;
  Snippet = &quot;En beretning om Danmarks nationale vartegn, &lt;b&gt;Den&lt;/b&gt; &lt;b&gt;lille&lt;/b&gt; &lt;b&gt;Havfrue&lt;/b&gt; ved Langelinie - Fakts&lt;br&gt; om havfruen, eventyret, skulpturen, og de mange h&aelig;rv&aelig;rk - billeder fra &lt;b&gt;...&lt;/b&gt;  &quot;
  Summary = &quot;Uofficiel side om &lt;b&gt;Den&lt;/b&gt; &lt;b&gt;lille&lt;/b&gt; &lt;b&gt;Havfrue&lt;/b&gt; ved Langelinie - Fakts om havfruen, eventyret, skulpturen, og...&quot;
  Cached Size = &quot;10k&quot;
  ],

  [
  URL  = &quot;http://hjem.get2net.dk/chenero/hca/hcaev008_da.html&quot;
  Title = &quot;&lt;b&gt;Den&lt;/b&gt; &lt;b&gt;lille&lt;/b&gt; &lt;b&gt;havfrue&lt;/b&gt;&quot;
  Snippet = &quot;&lt;b&gt;Den&lt;/b&gt; &lt;b&gt;lille&lt;/b&gt; &lt;b&gt;havfrue&lt;/b&gt;. af Hans Christian Andersen. &lt;b&gt;...&lt;/b&gt; ?Det g&oslash;r ondt!? sagde &lt;b&gt;den&lt;/b&gt; &lt;b&gt;lille&lt;/b&gt; &lt;b&gt;havfrue&lt;/b&gt;.&lt;br&gt; ?Ja man m&aring; lide noget for stadsen!? sagde &lt;b&gt;den&lt;/b&gt; gamle. Oh! &lt;b&gt;...&lt;/b&gt;  &quot;
  Summary = &quot;&quot;
  Cached Size = &quot;47k&quot;
  ],

  [
  URL  = &quot;http://www.hcandersen-homepage.dk/skulptur_den_lille_havfrue.htm&quot;
  Title = &quot;HC Andersen: Skulptur &amp;quot;&lt;b&gt;Den&lt;/b&gt; &lt;b&gt;lille&lt;/b&gt; &lt;b&gt;havfrue&lt;/b&gt;&amp;quot;&quot;
  Snippet = &quot;..... Skulptur &amp;quot;&lt;b&gt;Den&lt;/b&gt; &lt;b&gt;lille&lt;/b&gt; &lt;b&gt;havfrue&lt;/b&gt;&amp;quot;. hans christian andersen homepage odense&lt;br&gt; denmark. ..... &lt;b&gt;...&lt;/b&gt; &lt;b&gt;den&lt;/b&gt; &lt;b&gt;lille&lt;/b&gt; &lt;b&gt;havfrue&lt;/b&gt; - &amp;quot;The mermaid&amp;quot;, Havfruen. &lt;b&gt;...&lt;/b&gt;  &quot;
  Cached Size = &quot;14k&quot;
  ],
  }
}</PRE>
<H3 CLASS="western">11.5.5 <a name='afsn11.5.5'></a>Genere Java-API fra webtjeneste (WSDL)</H3>
<P CLASS="western">Du kan ogs&aring; genere APIet i dit eget sprog ud
fra webtjenestebeskrivelsen (WSDL) med et v&aelig;rkt&oslash;j.
Herunder er beskrevet, hvordan et API kan genereres i Java ud fra en
webtjeneste med Oracle JDeveloper og Apache Axis.</P>
<H4 CLASS="western">Oracle JDeveloper</H4>
<P CLASS="western">&Aring;bn beskrivelsen af tjenesten (WSDL-filen),
h&oslash;jreklik p&aring; den og v&aelig;lg &quot;Generate Web
Service Stub/Skeleton&quot; og gener&eacute;r en klient-side stub med
en main()-metode. 
</P>
<H4 CLASS="western">Apache Axis</H4>
<P CLASS="western">I Apache Axis' API kan man f&aring; dannet en WSDL
p&aring; to m&aring;der: 
</P>
<OL>
  <LI><P CLASS="western"><SPAN LANG="da-DK">Den ene m&aring;de er, at
  idrifts&aelig;tte sin webtjeneste ud fra en XML-fil, som er en
  WSDD-fil, WebService Definition Document. Axis vil derefter starte
  webtjenesten og danne WSDL-filen. Man kan derefter se filen, ved at
  skrive webtjenestens URL i adressefeltet </SPAN>p&aring; sin
  netl&aelig;ser, men efter webtjenestens navn tilf&oslash;je
  parameteren wsdl, f.eks.:<BR>
  <A CLASS="western" HREF="http://localhost:8080/jboss-net/services/Veksletjeneste?wsdl">http://localhost:8080/jboss-net/services/Veksletjeneste<B>?wsdl</B></A></P>
  <LI><P CLASS="western">Man kan ogs&aring; benytte det medf&oslash;lgende
  program, Java2WSDL, som kan producere <SPAN LANG="da-DK">WSDL-dokumentet
  ud fra den Java-klasse, som man vil udbyde som en webtjeneste.
  Programmet Java2WSDL tager 3 parametre, ud over Javaklassens fulde
  navn: Navnet p&aring; WSDL-filen, webtjenestens URL og et &quot;target
  namespace&quot;, som skal v&aelig;re et entydigt navn p&aring;
  webtjenesten.</SPAN></P>
</OL>
<H4 CLASS="western">&Oslash;velse</H4>
<P CLASS="western">G&oslash;r ovenst&aring;ende med Googles WSDL-fil
(GoogleSearch.wsdl). Kig filerne igennem og g&aring; derp&aring; ind
i GoogleSearchServiceStub og ret main() til:</P>
<PRE CLASS="kode-western"><I>  // opret stubben</I>
<SPAN LANG="da-DK">  GoogleSearchServiceStub stub = new GoogleSearchServiceStub();</SPAN>

<SPAN LANG="da-DK"><I>  // foretag s&oslash;gningen</I></SPAN>
<SPAN LANG="da-DK">  GoogleSearchResult sr=stub.doGoogleSearch(&quot;VKjZ2P5QFHICg5MfvjuwzmJm1T/iYbdY&quot;,</SPAN>
<SPAN LANG="da-DK">    &quot;Den lille havfrue&quot;,new Integer(0),new Integer(10),</SPAN>
<SPAN LANG="da-DK">    Boolean.FALSE,null,Boolean.FALSE,null,null,null);</SPAN>

<SPAN LANG="da-DK"><I>  // genneml&oslash;b resultaterne</I></SPAN>
<SPAN LANG="da-DK">  ResultElement[] re = sr.getResultElements();</SPAN>
<SPAN LANG="da-DK">  for (int i=0; i&lt;re.length; i++) </SPAN>
<SPAN LANG="da-DK">    System.out.println(re[i].getTitle() +&quot; &quot;+re[i].getURL());</SPAN></PRE><P CLASS="western">
... og k&oslash;r programmet (husk at udskifte n&oslash;glen med din
egen n&oslash;gle). Ud skulle gerne, som f&oslash;r, komme en r&aelig;kke
adresser p&aring; sider om den lille havfrue.</P>

<H3 CLASS="western">11.5.6 <a name='afsn11.5.6'></a>Generere <SPAN LANG="da-DK">webtjeneste
(WSDL)</SPAN> fra Java-klasse</H3>
<P CLASS="western"><SPAN LANG="da-DK">Opret eller find en simpel
klasse med nogle metoder, du kunne t&aelig;nke dig at udbyde som en</SPAN>
webtjeneste. 
</P>
<P CLASS="western">Lav f.eks. en klasse, der kan konvertere mellem
dollar og euro:</P>
<PRE CLASS="kode-western">package webtjeneste;

public class Veksler 
{
  public double euroTilDollar(double euro)
  {
    System.out.println(&quot;euroTilDollar(&quot;+euro+&quot;) kaldt!&quot;);
    return euro/1.1;
  }

  public double dollarTilEuro(double dollar)
  {
    System.out.println(&quot;dollarTilEuro(&quot;+dollar+&quot;) kaldt!&quot;);
    return dollar*1.1;
  }
}</PRE><H4 CLASS="western">
O<SPAN LANG="da-DK">racle JDeveloper</SPAN></H4>
<UL>
  <LI><P CLASS="western"><SPAN LANG="da-DK">H&oslash;jreklik derefter
  p&aring; klassen og v&aelig;lg 'Create J2EE Web Service'.</SPAN> 
  </P>
  <LI><P CLASS="western">Dobbeltklik p&aring; den genererede fil og
  giv tjenesten et navn (f.eks. navnet MinTjeneste). 
  </P>
  <LI><P CLASS="western">H&oslash;jreklik p&aring; filen og v&aelig;lg
  'Run'</P>
</UL>
<P CLASS="western">... <SPAN LANG="da-DK">og du har en webtjeneste
k&oslash;rende!</SPAN></P>
<P CLASS="western">Tjenesten k&oslash;rer i Oracle JDevelopers
interne webserver. For at afpr&oslash;ve den, kan du  genere en
Java-klient fra WSDL-webtjenestebeskrivelsen, som beskrevet i forrige
afsnit.</P>
<H4 CLASS="western">Apache Axis</H4>
<P CLASS="western">Axis stiller et program til r&aring;dighed, der
kan danne Javastubbene til kommunikation med en webtjeneste ud fra
webtjenestens WSDL. Dette program hedder WSDL2Java og tager to
parametre: et pakkenavn til stub-klasserne og filnavnet p&aring;
WSDL-filen.</P>
<H3 CLASS="western">11.5.7 <a name='afsn11.5.7'></a>Avanceret: Strukturen i WSDL- og SOAP-filer</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_JSP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/JSP/kapitel11.jsp#afsn11.5.7">
  <input type='checkbox' name='vis' value='11.5.7'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='11.5.7'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">11.5.8 <a name='afsn11.5.8'></a>Yderligere l&aelig;sning</H3>
<UL>
  <LI><P CLASS="western">Suns portal om webtjenester:<BR>
  <A CLASS="western" HREF="http://java.sun.com/webservices/">http://java.sun.com/webservices/</A>
  
  </P>
  <LI><P CLASS="western"><SPAN LANG="da-DK">Apache-gruppens
  </SPAN>implementering af webtjenester (<SPAN LANG="da-DK">Axis)</SPAN>:<BR><SPAN LANG="da-DK">
  </SPAN><A CLASS="western" HREF="http://ws.apache.org/axis/java/"><SPAN LANG="da-DK">http://ws.apache.org/axis/java/</SPAN></A>
  
  </P>
  <LI><P CLASS="western"><SPAN LANG="da-DK">Oracle JDeveloper har
  meget kraftig underst&oslash;ttelse af webtjenester. En lang r&aelig;kke
  artikler om webtjenester og Oracle JDeveloper kan ses p&aring;<BR></SPAN>
  <A CLASS="western" HREF="http://www.oracle.com/technology/tech/webservices/htdocs/series/">http://www.oracle.com/technology/tech/webservices/htdocs/series/</A>
  og<BR><SPAN LANG="da-DK">
  </SPAN><A CLASS="western" HREF="http://www.oracle.com/technology/tech/webservices/"><SPAN LANG="da-DK">http://www.oracle.com/technology/tech/webservices/</SPAN></A><SPAN LANG="da-DK">
  </SPAN>
  </P>
  <LI><P CLASS="western">S&oslash;geportalen Googles webtjenester:<BR>
  <A CLASS="western" HREF="http://www.google.com/apis/">http://www.google.com/apis/</A>
  
  </P>
  <LI><P CLASS="western">E-handelssiden Amazons webtjenester:<BR>
  <A CLASS="western" HREF="http://soap.amazon.com/">http://soap.amazon.com/</A>
  
  </P>
  <LI><P CLASS="western">Auk<SPAN LANG="da-DK">tionssiden Ebays
  webtjenester:<BR> </SPAN><A CLASS="western" HREF="http://developer.ebay.com/DevProgram/"><SPAN LANG="da-DK">http://developer.ebay.com/DevProgram/</SPAN></A><SPAN LANG="da-DK">
  </SPAN>
  </P>
  <LI><P CLASS="western">Liste over firmaer, der udbyder
  webtjenester:<BR>  <A CLASS="western" HREF="http://uddi.xmethods.net/">http://uddi.xmethods.net/</A></P>
</UL>

<H2 CLASS="western">11.6 <a name='afsn11.6'></a>Test dig selv</SPAN></H2>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_JSP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/JSP/kapitel11.jsp#afsn11.6">
  <input type='checkbox' name='vis' value='11.6'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='11.6'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H2 CLASS="western">11.7 <a name='afsn11.7'></a>Resum&eacute;</SPAN></H2>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_JSP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/JSP/kapitel11.jsp#afsn11.7">
  <input type='checkbox' name='vis' value='11.7'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='11.7'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <DIV ID="sdfootnote1">
  <P CLASS="sdfootnote-western"><A CLASS="sdfootnotesym" NAME="sdfootnote1sym" HREF="#sdfootnote1anc">1</A><SPAN LANG="da-DK">Vigtigste
  forskel er nok at &lt;item&gt;-indgangene i RSS 1.0 er <I>sideordnet</I>
  med &lt;channel&gt;, hvor de i version 0.91 ligger <I>under</I>
  &lt;channel&gt;-indgangen.</SPAN></P>
</DIV>

<a href='http://javabog.dk/'>javabog.dk</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel10.jsp'>&lt;&lt; forrige</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='indhold.jsp'>indhold</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel12.jsp'>n&aelig;ste &gt;&gt;</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kode/'>programeksempler</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='../index_JSP.html'>om bogen</a>
<hr>
<font size=-2>http://javabog.dk/ - <b>Webprogrammering med Java Server Pages</b> af Jacob Nordfalk.
<br>
  Licens og kopiering under <a href='http://www.linuxbog.dk/licens.html'>&Aring;ben Dokumentlicens</a> (&Aring;DL)
  hvor intet andet er nvnt (72% af vrket).
</font>
<br>
nsker du at se de sidste 28% af dette vrk (275315 tegn)
skal du kbe bogen. S fr du pne figurer og layout, stikordsregister og en trykt bog med i kbet.
<!-- netlser: Wget/1.10, autoHent: true  -->
     

</body>
</html>
